import { headers } from "next/headers";
import dynamic from "next/dynamic";
import { FetchData } from "@/libs/api";
import { localhostdomain, WorkDomain } from "@/app/domain";
import { notFound } from "next/navigation";
const ContentSec = dynamic(() => import("@/sections/ContentSec"));
const OffPlanCardsList = dynamic(() => import("@/sections/OffPlanCardsList"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
export async function generateMetadata({ params }) {
  const { developer_name } = params;
  const slug = developer_name;
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "developer-detail";
  const data = await FetchData(domain, first_para, slug);
  if (data === null) {
    notFound();
  }
  const { meta_title, meta_desc, meta_keywords } = data;
  return {
    metadataBase: new URL(`https://${domain}/developers/${slug}`),
    title: meta_title,
    description: meta_desc,
    keywords: meta_keywords,
    alternates: {
      canonical: "/",
    },
    openGraph: {
      url: "/",
    },
  };
}
export default async function page({ params }) {
  const { developer_name } = params;
  const slug = developer_name;
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const parameter = "developer-detail";
  const data = await FetchData(domain, parameter, slug);
  if (data === null) {
    notFound();
  }
  const {
    meta_title,
    meta_desc,
    meta_keywords,
    projects,
    short_content,
    full_content,
    heading,
  } = data;
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={`https://${domain}/developers/${slug}`}
      />
      <RatingSchema title={meta_title} />
      <OffPlanCardsList
        data={projects}
        heading={heading}
        content={short_content}
        domain={domain}
        cardsQuantity="12"
      />
      {full_content ? <ContentSec content={full_content} /> : ""}
    </>
  );
}
